// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300

#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
_centroid in highp vec2 uv;
#else
_centroid in vec2 uv;
#endif

#else

varying vec2 uv;

#endif

#include "uniformShaderConstants.h"
#include "util.h"

varying highp vec2 pos;

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;

#define skp 0.5

#include "flora.h"

void main()
{
#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE)
	vec4 diffuse = texture2D( TEXTURE_0, uv );
#else
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv );
#endif

#ifdef ALPHA_TEST
	if(diffuse.a < 0.5)
		discard;
#endif
  
  highp vec3 color;
  highp float cel = length(pos);
  highp float mu = smoothstep(.5,.0,cel)*pow(dd*1.2,3.);
  if(cel<.5)color += mix(color,skh*.05,mu);
  if(cel<.012+0.012*(1.-dd))color += skh*1.6;
  color *= 1.-rain;
  
	gl_FragColor = vec4(color,diffuse.a);
}
